/*"Gear Indicator": Simple OutGauge client for LFS
 * Author: Vladimir Kadlec
 *         vladimirkadlec@gmail.com
 *         http://www.fi.muni.cz/~xkadlec
 */
/*
This file is part of Gear Indicator.

Gear Indicator is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gear Indicator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gear Indicator; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <time.h>
#include <math.h>

#include "lpt.h"
#include "log.h"
#include "outsim.h"

//r, N, 1, 2, 3, 4, 5, 6, 7, 8
//char SEG_N[10] = {129, 131, 192, 87, 213, 225, 181, 183, 196, 247};
//char SEG_DOT = 8;
char Cars[20][4] = {"XFG","XRG","XRT","RB4","FXO","LX4","LX6","MRT","UF1","RAC","FZ5","XFR","UFR","FOX","FO8","BF1","FXR","XRR","FZR","FBM"};
int CarIdleRPM[20] = {1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1500,1500,2000,2000,3500,1500,1500,1500,2000};
int CarMaxRPM[20] = {8000,7000,7500,7500,7500,9000,9000,9000,7000,7000,8000,8000,9000,7500,9500,20000,7500,7500,8500,9200};
typedef short _stdcall (*inpfuncPtr)(short portaddr);
typedef void _stdcall (*oupfuncPtr)(short portaddr, short data);
short lpt_base_offset =0;
inpfuncPtr inp32;
oupfuncPtr oup32;

static clock_t last_t;
static int dot_state = 0;

int init_lpt (int base) {
HINSTANCE hLib;

    hLib = LoadLibrary("inpout32.dll");
     if (hLib == NULL) {
          error ("LoadLibrary Failed.\n");
          return (0);
     }
     inp32 = (inpfuncPtr) GetProcAddress(hLib, "Inp32");
     if (inp32 == NULL) {
          error ("GetProcAddress for Inp32 Failed.\n");
          return (0);
     }

     oup32 = (oupfuncPtr) GetProcAddress(hLib, "Out32");
     if (oup32 == NULL) {
          error ("GetProcAddress for Oup32 Failed.\n");
          return (0);
     }
     last_t = clock();
    /* while (1) {
        (oup32) (0x378+2, 1);
        Sleep (100);
        (oup32) (0x378+2, 0);
        Sleep (100);
     }*/
	return (1);
}

int display_off (Config *conf) {
    (oup32) (conf->lpt_base, conf->disp_off);
    (oup32) (conf->lpt_base+2, conf->ext_off);
    return (1);
}

int display_lpt (Config *conf, OutGaugePacket *packet) {
char o;
clock_t act_t;
word flags;
short lptext_fl[5] = { 1, 128, 2, 4, 8 };//{1, 2, 4, 8};  // sizeof (PINS)
short pin_set[5] = { 1, 0, 1, 1, 1 }; // 0=standard pin set, 1=extended pin set. Assignments correspond to pins PIN 1, PIN 9, PIN 14, PIN 16, PIN 17
short res_fl = 0;
int i;
// DETERMINE CAR
int CarNo;
    for (i = 0; i < 20 ; i++) {
        if (strcasecmp (packet->Car, Cars[i]) == 0) {
           CarNo=i;
           }}
// GEAR
    if (packet->Gear < 9)
        o = conf->display[packet->Gear];
    else o = conf->disp_off;

// If pitspeed limiter is on, toggle dot_state for LED to flash
    flags = packet->Flags;
    if (flags & OG_PITSPEED) {
        act_t = clock ();
        if ( abs (act_t - last_t) > conf->blink_time ) {
            dot_state = !dot_state;
            last_t = act_t;
        }
    }

    for (i = 0; i < 5; i++) {  // sizeof (PINS)

        if (conf->pin_func[i] == F_NONE)
            continue;
// LOW FUEL
        if (conf->pin_func[i] == F_LOW_FUEL) {
            if (packet->Fuel >= conf->fuel_warning*0.01) {
                if (conf->pin_func_neg[i] != 0) {
					if (pin_set[i] == 1) {
        	              res_fl |= lptext_fl[i];
        	              continue;
					}
              	    o |= lptext_fl[i];
	                continue;
                }
                continue;
            }
            if (conf->pin_func_neg[i] == 0) {
				if (pin_set[i] == 1) {
					res_fl |= lptext_fl[i];
					continue;
				}
              	o |= lptext_fl[i];
	            continue;
            }
            continue;
        }
// SHIFT LIGHT / PIT SPEED LIMITER
        if (conf->pin_func[i] == F_SHIFT_LIGHT) {
    		if ((flags & OG_SHIFTLIGHT) || ((dot_state != 0) && (flags & OG_PITSPEED))) {
        	    if (conf->pin_func_neg[i] == 0) {
        	    	if (pin_set[i] == 1) {
						res_fl |= lptext_fl[i];
						continue;
					}
        	      	o |= lptext_fl[i];
	        	    continue;
				}
				continue;
			}
			if (conf->pin_func_neg[i] != 0) {
				if (pin_set[i] == 1) {
					res_fl |= lptext_fl[i];
					continue;
				}
              	o |= lptext_fl[i];
	            continue;
			}
			continue;
		}
// BRAKING LIGHT
		if (conf->pin_func[i] == F_BRAKING_LIGHTS) {
			if (packet->Brake != 0) {
	            if (conf->pin_func_neg[i] == 0) {
    	            if (pin_set[i] == 1) {
        	              res_fl |= lptext_fl[i];
        	              continue;
					}
              	    o |= lptext_fl[i];
	                continue;
    	        }
        	    continue;
	        }
	        if (conf->pin_func_neg[i] != 0) {
				if (pin_set[i] == 1) {
        	    	res_fl |= lptext_fl[i];
        	        continue;
				}      
              	o |= lptext_fl[i];
	            continue;
    	    }
        	continue;
		}
// REVERSE LIGHT
		if (conf->pin_func[i] == F_REVERSE_LIGHTS) {
			if (packet->Gear == 0) {
	            if (conf->pin_func_neg[i] == 0) {
    	            if (pin_set[i] == 1) {
        	              res_fl |= lptext_fl[i];
        	              continue;
					}
              	    o |= lptext_fl[i];
	                continue;
    	        }
        	    continue;
	        }
	        if (conf->pin_func_neg[i] != 0) {
				if (pin_set[i] == 1) {
        	    	res_fl |= lptext_fl[i];
        	        continue;
				}      
              	o |= lptext_fl[i];
	            continue;
    	    }
        	continue;
		}
// ENGINE RUNNING
		if (conf->pin_func[i] == F_ENGINE_RUNNING) {
			if (packet->RPM < 10) {
	            if (conf->pin_func_neg[i] == 0) {
    	            if (pin_set[i] == 1) {
        	              res_fl |= lptext_fl[i];
        	              continue;
					}
              	    o |= lptext_fl[i];
	                continue;
    	        }
        	    continue;
	        }
	        if (conf->pin_func_neg[i] != 0) {
				if (pin_set[i] == 1) {
        	    	res_fl |= lptext_fl[i];
        	        continue;
				}      
              	o |= lptext_fl[i];
	            continue;
    	    }
        	continue;
		}
// RPM
        if (conf->pin_func[i] == F_RPM1) {
            if (packet->RPM >= CarIdleRPM[CarNo]+(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.7+0*(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.3/5) {
                if (conf->pin_func_neg[i] == 0) {
                   if (pin_set[i] == 1)
                      res_fl |= lptext_fl[i];
                      else
                      o |= lptext_fl[i];
                    continue;
                }
                continue;
            }
            if (conf->pin_func_neg[i] != 0) {
               if (pin_set[i] == 1)
                  res_fl |= lptext_fl[i];
                  else
                  o |= lptext_fl[i];
                continue;
            }
            continue;
        }
        if (conf->pin_func[i] == F_RPM2) {
            if (packet->RPM >= CarIdleRPM[CarNo]+(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.7+1*(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.3/5) {
                if (conf->pin_func_neg[i] == 0) {
                   if (pin_set[i] == 1)
                      res_fl |= lptext_fl[i];
                      else
                      o |= lptext_fl[i];
                    continue;
                }
                continue;
            }
            if (conf->pin_func_neg[i] != 0) {
               if (pin_set[i] == 1)
                  res_fl |= lptext_fl[i];
                  else
                  o |= lptext_fl[i];
                continue;
            }
            continue;
        }
        if (conf->pin_func[i] == F_RPM3) {
            if (packet->RPM >= CarIdleRPM[CarNo]+(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.7+2*(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.3/5) {
                if (conf->pin_func_neg[i] == 0) {
                   if (pin_set[i] == 1)
                      res_fl |= lptext_fl[i];
                      else
                      o |= lptext_fl[i];
                    continue;
                }
                continue;
            }
            if (conf->pin_func_neg[i] != 0) {
               if (pin_set[i] == 1)
                  res_fl |= lptext_fl[i];
                  else
                  o |= lptext_fl[i];
                continue;
            }
            continue;
        }
        if (conf->pin_func[i] == F_RPM4) {
            if (packet->RPM >= CarIdleRPM[CarNo]+(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.7+3*(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.3/5) {
                if (conf->pin_func_neg[i] == 0) {
                   if (pin_set[i] == 1)
                      res_fl |= lptext_fl[i];
                      else
                      o |= lptext_fl[i];
                    continue;
                }
                continue;
            }
            if (conf->pin_func_neg[i] != 0) {

               if (pin_set[i] == 1)
                  res_fl |= lptext_fl[i];
                  else
                  o |= lptext_fl[i];
                continue;
            }
            continue;
        }
        if (conf->pin_func[i] == F_RPM5) {
            if (packet->RPM >= CarIdleRPM[CarNo]+(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.7+4*(CarMaxRPM[CarNo]-CarIdleRPM[CarNo])*0.3/5) {
                if (conf->pin_func_neg[i] == 0) {
                   if (pin_set[i] == 1)
                      res_fl |= lptext_fl[i];
                      else
                      o |= lptext_fl[i];
                    continue;
                }
                continue;
            }
            if (conf->pin_func_neg[i] != 0) {
                if (pin_set[i] == 1)
                   res_fl |= lptext_fl[i];
                   else
                   o |= lptext_fl[i];
                continue;
            }
            continue;
        }
// ALL OTHER FLAGS
        if (conf->pin_lfs_flag[i] & flags) {
            if (conf->pin_func_neg[i] == 0) {
                if (pin_set[i] == 1)
                      res_fl |= lptext_fl[i];
                      else
                      o |= lptext_fl[i];
                continue;
            }
            continue;
        }
        if (conf->pin_func_neg[i] != 0) {
            if (pin_set[i] == 1)
               res_fl |= lptext_fl[i];
               else
               o |= lptext_fl[i];
            continue;
        }
    }

    (oup32) (conf->lpt_base, o);
    (oup32) (conf->lpt_base+2, res_fl);
    return (1);
}
